/*  Setze für einen gegebenen AG die noch notwendige Arbeitszeit.

    Bei Parameter _add_blocktimes = true wird der AG mit Hilfe der Funktion
    "scheduling.resource_timeline__ab2__retermination_fragmented" mit dem ursprünglichen Startzeitpunkt und der neuen gplanten
    Laufzeit neu terminiert.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__required_worktime__set', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__required_worktime__set(
      IN _ab2_id                int,                                    -- ID des AG, für den die Vorgabearbeitszeit (Spalte a2w_stukorr) geändert werden soll.
      IN _required_work         numeric,                                -- Die zu setzende neue Vorgabearbeitszeit.
      IN _add_blocktimes        bool = true,                            -- Parameter gibt an, ob entsprechend der neuen Vorgabearbeitszeit Blockierungen angehängt bzw. reduziert werden sollen.
      IN _timeframe_start       timestamp DEFAULT null,                 -- Maximum des Zeitbereichs, in dem die ABK einterminiert werden soll. Passt die ABK nicht in den Zeitbereich, schlägt Terminierung mit Exception fehl. Überschreibt den ursprünglichen Beginn als Strattermin für Reterminierung.
      IN _timeframe_end         timestamp DEFAULT null,                 -- Maximum des Zeitbereichs, in dem die ABK einterminiert werden soll. Passt die ABK nicht in den Zeitbereich, schlägt Terminierung mit Exception fehl.
      IN _blocktime_date_start  timestamp = null,                       -- Parameter gibt an, ab welchem frühesten Zeitpunkt Blockierungen in der Timeline angelegt werden dürfen.
      IN _loglevel              int DEFAULT TSystem.Log_Get_LogLevel()
  ) RETURNS bool AS $$
  DECLARE
      _prefix   varchar := format( 'ab2__required_worktime__set AG %L -', _ab2_id );

      _row_count   int;
      _scheduled_work numeric := scheduling.resource_timeline__ab2__get_scheduled_time( _ab2_id => _ab2_id ); -- enthält auch Überhänge
      _ab2 ab2;

  BEGIN
      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '%',
              format(
                  $call$
                      call: scheduling.ab2__required_worktime__set(
                          _ab2_id => %L,
                          _required_work => %L,
                          _add_blocktimes => %L,
                          _timeframe_start => %L,
                          _timeframe_endrt => %L,
                          _blocktime_date_start => %L,
                          _loglevel => %L
                      )
                  $call$,
                  _ab2_id, _required_work,
                  _add_blocktimes, _timeframe_start, _timeframe_end, _blocktime_date_start,
                  _loglevel
              )
          ;
      END IF;

      IF ( _required_work < 0 OR _required_work IS NULL ) THEN
          RAISE EXCEPTION 'illegal value for _required_work: %', _required_work;
      END IF;

      UPDATE ab2_wkstplan
         SET a2w_stukorr = _required_work / ( 60 * 60 )
       WHERE a2w_a2_id = _ab2_id;

      GET DIAGNOSTICS _row_count = ROW_COUNT;

      IF ( _row_count = 0 ) THEN
          RAISE EXCEPTION 'illegal ab2_id: %', _ab2_id;
      END IF;

      -- Der AG soll an die neue noch notwendige Arbeitszeit angepasst werden (ggf. sollen Blockierungen gebildet werden), ...
      IF _add_blocktimes THEN
          _ab2 := ab2
             FROM ab2
             WHERE a2_id = _ab2_id;

          -- ... dann AG mit der neuen notwendige Arbeitszeit erneut terminieren.
          PERFORM scheduling.resource_timeline__ab2__retermination_fragmented(
                      _ab2                  => _ab2,
                      _timeframe_start      => _timeframe_start,
                      _timeframe_end        => _timeframe_end,
                      _blocktime_date_start => _blocktime_date_start,
                      _loglevel             => _loglevel
                  )
          ;
      END IF;

      RETURN true;

  END $$ LANGUAGE plpgsql;
--